<?php
/**
 * Get Knowledge Base Endpoint
 * Returns all knowledge entries for the authenticated vendor
 */

header('Content-Type: application/json');
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth_middleware.php';

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    // Authenticate vendor
    $vendorId = AuthMiddleware::getVendorId();
    
    $db = getDB();
    $stmt = $db->prepare("
        SELECT id, content_type, raw_content, qdrant_point_id, created_at
        FROM knowledge_base
        WHERE vendor_id = ?
        ORDER BY created_at DESC
    ");
    $stmt->execute([$vendorId]);
    $entries = $stmt->fetchAll();
    
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'entries' => $entries,
        'count' => count($entries)
    ]);
    
} catch (Exception $e) {
    error_log("Get knowledge base error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
