<?php
/**
 * Vendor Logout Endpoint
 * Clears JWT token cookie
 */

header('Content-Type: application/json');
require_once __DIR__ . '/../includes/jwt_helper.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Clear token cookie
JWTHelper::clearTokenCookie();

http_response_code(200);
echo json_encode([
    'success' => true,
    'message' => 'Logged out successfully'
]);
